/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Data;
using System.Collections;
using System.Collections.Specialized;
using System.Globalization;

using Borland.Eco.Support;
using Borland.Eco.DataRepresentation;
using Borland.Eco.Persistence.Connection;
using Borland.Eco.Persistence.Configuration;

namespace Borland.Eco.Persistence
{
	/// <summary>
	/// This class is suitable for subclassing if you intend to implement the IKeyMapper interface
	/// </summary>
	public class GenericKeyMapper: System.Object
	{
		private SqlDatabaseConfig m_SqlDatabaseConfig;
		private PersistenceMapperDictionary m_MapperDictionary;
		private ArrayList m_KeyMappers;

		private string GetStringRep(object value, ISingleColumnAttributemapping keyMapper)
		{
			string s;
			if (value is System.DateTime)
				s = ((System.DateTime)value).ToString(SqlDatabaseConfig.DateTimeFormat);
			else if (value is System.Guid)
				s = ((System.Guid)value).ToString("N");
			else
				s = value.ToString();
			return keyMapper.DefaultDbValue(s, SqlDatabaseConfig);
		}

		private string GetParamStr(ObjectId id, int index, bool useParams, IParameterized parameterized, ISingleColumnAttributemapping mapper)
		{
			string paramName;
			string res;
			IDataParameter param;
			System.Object value;
			if (useParams)
			{
				paramName = "ID" + index.ToString(CultureInfo.InvariantCulture); // do not localize
				res = ":" + paramName; // do not localize
				if (parameterized != null)
				{
					param = parameterized.ParamByName(paramName);
					value = id.Key;
					mapper.ValueToParameter(value, param);
				}
			}
			else
				res = GetStringRep(id.Key, GetKeyMapper(0));
			return res;
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="idList"/> is null</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="idColumns"/> is null</exception>
		protected string InternalIdListToWhereFragment(ObjectIdCollection idList, IParameterized parameterized, StringCollection idColumns, ISingleColumnAttributemapping mapper)
		{
			if (idList == null) throw new ArgumentNullException("idList"); // Do not localize
			if (idColumns == null) throw new ArgumentNullException("idColumns"); // Do not localize
			bool useParams = idList.Count <= SqlDatabaseConfig.MaxParamsInIdList;
			string res = idColumns[0];
			if (idList.Count == 1)
			{
				res += " = " + GetParamStr(idList.Any, 0, useParams, parameterized, mapper);
			}
			else
			{
				StringCollection tempList = new StringCollection();
				int i = 1;
				foreach (ObjectId id in idList)
				{
					tempList.Add(GetParamStr(id, i, useParams, parameterized, mapper));
					i++;
				}
				res += EcoSupport.SeparateStringCollection(tempList, ", ", " IN (", ")"); // do not localize
			}
			return res;
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="sqlDatabaseConfig"/> is null</exception>
		protected void InternalInitialize(SqlDatabaseConfig sqlDatabaseConfig, ArrayList keyMappers)
		{
			if (sqlDatabaseConfig == null) throw new ArgumentNullException("sqlDatabaseConfig"); // do not localize
			m_SqlDatabaseConfig = sqlDatabaseConfig;
			m_MapperDictionary = sqlDatabaseConfig.PersistenceMappers.GetMapperDictionary();
			m_KeyMappers = keyMappers;
		}

		public SqlDatabaseConfig SqlDatabaseConfig { get { return m_SqlDatabaseConfig; } }
		public PersistenceMapperDictionary MapperDictionary { get { return m_MapperDictionary; } }
		public ArrayList KeyMappers { get { return m_KeyMappers; } }
		public ISingleColumnAttributemapping GetKeyMapper(int index)
		{
			return KeyMappers[index] as ISingleColumnAttributemapping;
		}
	}
}


